var advanceMenu = {
    status_menu:{
        value: menuStr.status,
        url: "../userRpm/StatusRpm.htm",
        hasSub: false
    },    
    normal_network_menu:{
        value: menuStr.network,
        url: "../userRpm/WanCfgRpm.htm",
        hasSub: true,
        subMenu:
        [
            {
                value: menuStr.lan,
                url: "../userRpm/NetworkCfgRpm.htm"
            }
        ]
    },
    wireless_24g_menu:{
        value: menuStr.wireless24g,
        url: "../userRpm/WlanNetworkRpm.htm",
        hasSub: true,
        subMenu:
        [
            {
                value: menuStr.wirelessSettings,
                url: "../userRpm/WlanNetworkRpm.htm"
            },
            {
                value: menuStr.wps,
                url: "../userRpm/WlanWpsRpm.htm"
            },
            {
                value: menuStr.wirelessSecurity,
                url: "../userRpm/WlanSecurityRpm.htm"
            },
            {
                value: menuStr.wirelessMacFiltering,
                url: "../userRpm/WlanMacFilterRpm.htm"
            },
            {
                value: menuStr.wirelessAdvanced,
                url: "../userRpm/WlanAdvRpm.htm"
            },
            {
                value: menuStr.wirelessStatistics,
                url: "../userRpm/WlanStationRpm.htm"
            }
        ]
    },
    wireless_5g_menu:{
        value: menuStr.wireless5g,
        url: "../userRpm/WlanNetworkRpm_5g.htm",
        hasSub: true,
        subMenu:
        [
            {
                value: menuStr.wirelessSettings,
                url: "../userRpm/WlanNetworkRpm_5g.htm"
            },
            {
                value: menuStr.wps,
                url: "../userRpm/WlanWpsRpm_5g.htm"
            },
            {
                value: menuStr.wirelessSecurity,
                url: "../userRpm/WlanSecurityRpm_5g.htm"
            },
            {
                value: menuStr.wirelessMacFiltering,
                url: "../userRpm/WlanMacFilterRpm_5g.htm"
            },
            {
                value: menuStr.wirelessAdvanced,
                url: "../userRpm/WlanAdvRpm_5g.htm"
            },
            {
                value: menuStr.wirelessStatistics,
                url: "../userRpm/WlanStationRpm_5g.htm"
            }
        ]
    },  
	plc_menu:{
        value: menuStr.plc,
        url: "../userRpm/PlcNetworkCfgRpm.htm",
        hasSub: true,
        subMenu:
        [
            {
                value: menuStr.plcNetwork,
                url: "../userRpm/PlcNetworkCfgRpm.htm"
            },
            {
                value: menuStr.plcStation,
                url: "../userRpm/PlcStationCfgRpm.htm"
            }
        ]
    },
    system_tools_menu:{
        value: menuStr.systemTools,
        url: "../userRpm/DateTimeCfgRpm.htm",
        hasSub: true,
        subMenu:
        [
{
                value: menuStr.timeSettings,
                url: "../userRpm/DateTimeCfgRpm.htm"
            },
            {
                value: menuStr.diagnostic,
                url: "../userRpm/DiagnosticRpm.htm"
            },
            {
                value: menuStr.firmwareUpgrade,
                url: "../userRpm/SoftwareUpgradeRpm.htm"
            },
            {
                value: menuStr.factoryDefaults,
                url: "../userRpm/RestoreDefaultCfgRpm.htm"
            },
            {
                value: menuStr.backupAndRestore,
                url: "../userRpm/BakNRestoreRpm.htm"
            },
            {
                value: menuStr.reboot,
                url: "../userRpm/SysRebootRpm.htm"
            },
            {
                value: menuStr.password,
                url: "../userRpm/ChangeLoginPwdRpm.htm"
            },
            {
                value: menuStr.systemLog,
                url: "../userRpm/SystemLogRpm.htm"
            }
        ]
    }
};

var basicMenu = {
    network_map_menu:{
        value: menuStr.networkMap,
        url: "../userRpm/BasicNetworkMapRpm.htm",
        hasSub: false
    },
    wireless_menu:{
        value: menuStr.wireless,
        url: "../userRpm/BasicWirelessRpm.htm",
        hasSub: false
    }    
};

var colF = "#252525";
var colS = "#1f8eff";
var colT = "#0052a4";
var isExplorerIE = false;
(function (){
    if (navigator.userAgent.indexOf("MSIE") >= 0)
    {
        isExplorerIE = true;
    }
})();

function goTop(callback)
{
    var time = 100, /* hole time */
        perTime = 20,
        st = ("pageYOffset" in window) ? window.pageYOffset : window.document.documentElement.scrollTop,
        speed = st / (time / perTime);

    window.setTimeout(function (){
        if (st <= 0)
        {
            window.scroll(0, 0);
            if (callback)
            {
                callback();
            }
            return;
        }
        st -= speed;
        window.scroll(0, st);
        window.setTimeout(arguments.callee, perTime);
    }, perTime);
}

function menuClick(menuid, url)
{
    var menuUl = id("menuUl"),
        subLi = menuUl.childNodes,
        targetUrl = "",
        autoJump = true,
        nocacheStr = isExplorerIE ? ("?_=" + (new Date()).getTime()) : "";  /* for IE cache bug */
    for(var i = 0, j =subLi.length; i < j; i++)
    {
        if (subLi[i].nodeType != 1)
        {
            continue;
        }
        
        var subLiClassName = subLi[i].className;
        if (subLiClassName.indexOf("fst") >= 0)
        {
            if (subLi[i].id == menuid)
            {
                $(subLi[i]).addClass("selected").find("label").addClass("selected");
                targetUrl = url;
            }
            else
            {
                $(subLi[i]).removeClass("selected").find("label").removeClass("selected");
            }
        }
        else
        {
            if (subLi[i].id.indexOf(menuid) >= 0)
            {
                var num = parseInt(subLi[i].id.substring(menuid.length));
                if (num == 0)
                {
                    /* $(subLi[i]).addClass("selected"); */
                    autoJump = false;
                }
                
                $(subLi[i]).removeClass("selected");
                
                subLi[i].style.display = "block";
            }
            else
            {
                subLi[i].style.display = "none";
            }
        }
    }

    window.onresize();

    if (autoJump)
    {
        goTop(function (){
            id("frame").src = targetUrl + nocacheStr;
        });
    }
}
function subMenuClick(menuid, subMenuId, url)
{
    var menuUl = id("menuUl"),
        subLi = menuUl.childNodes,
        subClassName = null,
        nocacheStr = isExplorerIE ? ("?_=" + (new Date()).getTime()) : "";  /* for IE cache bug */
    
    for (var i = 0, j =subLi.length; i < j; i++)
    {
        subClassName = subLi[i].className;
        if (subClassName.indexOf("sec") >= 0)
        {
            if (subLi[i].id == subMenuId)
            {
                $(subLi[i]).addClass("selected");
                goTop(function (){
                    id("frame").src = url + nocacheStr;
                });
            }
            else if (subLi[i].id.indexOf(menuid) >= 0)
            {
                $(subLi[i]).removeClass("selected");
            }
        }
    }
}
function menuMSOn()
{
    var className = this.className;
    if (className == "menuLi" || className == "subMenuLi")
    {
        this.style.color = colS;
    }
}
function menuMSOut()
{
    var className = this.className;
    if (className == "menuLi" || className == "subMenuLi")
    {
        this.style.color = colF;
    }
}

function menuInit(type)
{
    var menuUl = id("menuUl");
    var n = 0;
    var menu = (type === "advanced" ? advanceMenu : basicMenu);
    var fstLi = null;
    for(var menuObj in menu)
    {
        var menuObject = menu[menuObj];
        var li = document.createElement("li");
        if (n == 0)
        {
            fstLi = li;
        }
        li.id = menuObj.toString();
        li.className = "fst";
        li.onclick = new Function("menuClick('" + menuObj.toString() + "', '" + menuObject.url + "')");
        
        var lbl = document.createElement("label");
        lbl.innerHTML = menuObject.value;
        lbl.className = "fst";
        li.appendChild(lbl);
        menuUl.appendChild(li);
        
        var spanIcon = document.createElement("span");
        spanIcon.className = "icon";
        lbl.appendChild(spanIcon);
        
        if (menuObject.hasSub)
        {
            var subMenu = menuObject.subMenu,
                subLi = null;
            for(var i in subMenu)
            {
                subLi = document.createElement("li");
                subLi.id = (menuObj.toString() + i);
                if (i == 0)
                {
                    subLi.style.paddingTop = "12px";
                }
                /* subLi.className = "sec" +  (i == 0 ? " selected" : ""); */
                subLi.className = "sec";
                subLi.style.display = "none";
                subLi.onclick = new Function("subMenuClick('"+menuObj.toString()+"', '"+subLi.id+"', '"+subMenu[i].url+"')");
                
                var lbl = document.createElement("label");
                lbl.innerHTML = subMenu[i].value;
                lbl.className = "sec";
                subLi.appendChild(lbl);
                menuUl.appendChild(subLi);
            }
            subLi.style.borderBottom = "1px solid #D9D9D9";
        }
        else
        {
            lbl.className += " none-sec"
        }
        n++;
    }
    fstLi.onclick();
}
